<?php
/**
 * Plugin Name: Trackveil Analytics
 * Plugin URI: https://trackveil.net
 * Description: Privacy-first analytics that actually works everywhere. One-click setup, no configuration needed.
 * Version: 1.0.0
 * Author: Trackveil
 * Author URI: https://trackveil.net
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.8
 * Tested up to: 6.7
 * Requires PHP: 7.2
 * Text Domain: trackveil-analytics
 * Domain Path: /languages
 * Network: true
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Plugin constants
define('TRACKVEIL_VERSION', '1.0.0');
define('TRACKVEIL_FILE', __FILE__);
define('TRACKVEIL_DIR', plugin_dir_path(__FILE__));
define('TRACKVEIL_URL', plugin_dir_url(__FILE__));
define('TRACKVEIL_CDN', 'https://cdn.trackveil.net/tracker.min.js');
define('TRACKVEIL_API', 'https://api.trackveil.net');
define('TRACKVEIL_DASHBOARD', 'https://dashboard.trackveil.net');

// Load plugin files
require_once TRACKVEIL_DIR . 'includes/class-admin.php';
require_once TRACKVEIL_DIR . 'includes/class-frontend.php';
require_once TRACKVEIL_DIR . 'includes/class-api.php';
require_once TRACKVEIL_DIR . 'includes/class-dashboard-widget.php';

// Initialize plugin
add_action('plugins_loaded', 'trackveil_init');

function trackveil_init() {
    // Load text domain for translations
    load_plugin_textdomain('trackveil-analytics', false, dirname(plugin_basename(__FILE__)) . '/languages');
    
    // Initialize classes
    Trackveil_Admin::init();
    Trackveil_Frontend::init();
    Trackveil_API::init();
    Trackveil_Dashboard_Widget::init();
}

// Activation hook
register_activation_hook(__FILE__, 'trackveil_activate');

function trackveil_activate() {
    // Set default options
    if (!get_option('trackveil_skip_admins')) {
        add_option('trackveil_skip_admins', '1');
    }
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'trackveil_deactivate');

function trackveil_deactivate() {
    // Nothing to do on deactivation
}

// Uninstall hook (in separate uninstall.php file)

