<?php
/**
 * Trackveil Frontend Class
 * Handles tracker script injection
 */

if (!defined('ABSPATH')) {
    exit;
}

class Trackveil_Frontend {
    
    public static function init() {
        add_action('wp_head', [__CLASS__, 'inject_tracker'], 10);
    }
    
    /**
     * Inject Trackveil tracker script
     */
    public static function inject_tracker() {
        $site_id = get_option('trackveil_site_id');
        
        // Don't inject if no site ID configured
        if (empty($site_id)) {
            return;
        }
        
        // Check if we should skip tracking for this user
        if (!self::should_track()) {
            return;
        }
        
        // Output tracker script
        printf(
            '<script async src="%s" data-site-id="%s"></script>' . "\n",
            esc_url(TRACKVEIL_CDN),
            esc_attr($site_id)
        );
    }
    
    /**
     * Determine if current user should be tracked
     */
    private static function should_track() {
        // Check if we should skip admins
        $skip_admins = get_option('trackveil_skip_admins', true);
        
        if ($skip_admins && current_user_can('manage_options')) {
            return false;
        }
        
        return true;
    }
}

